package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.Layout;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.series.SeriesHeatmap;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class HeatMap extends DemoChartBase {
	private static final long serialVersionUID = -5694295632910678387L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.HEATMAP)
			.setMarginTop(40)
			.setMarginBottom(80)
			.setPlotBorderWidth(1);
		chartOptions.getTitle().setText("Sales per employee per weekday");
		
		XAxis xAxis = new XAxis();
		xAxis.setCategories(
			Arrays.asList("Alexander", "Marie", "Maximilian", "Sophia", "Lukas", "Maria", "Leon", "Anna", "Tim", "Laura"));
		chartOptions.getXAxis().add(xAxis);

		YAxis yAxis = new YAxis();
		yAxis.setCategories(Arrays.asList("Monday", "Tuesday", "Wednesday", "Thursday", "Friday"));
		yAxis.getTitle().setText(null);
		chartOptions.getYAxis().add(yAxis);
		
		chartOptions.getColorAxisSingle()
			.setMin(0)
			.setMinColor(new Color("#FFFFFF"))
			.setMaxColor(chartOptions.getColors().get(0));
		
		chartOptions.getLegend()
			.setAlign(HorizontalAlign.RIGHT)
			.setLayout(Layout.VERTICAL)
			.setMargin(0)
			.setVerticalAlign(VerticalAlign.TOP)
			.setY(25)
			.setSymbolHeight(328);
		
		chartOptions.getTooltip().getFormatter()
			.setFunctionBody("return '<b>' + this.series.xAxis.categories[this.point.x] + '</b> sold <br><b>' + this.point.value + '</b> items on <br><b>' + this.series.yAxis.categories[this.point.y] + '</b>';");
		
		SeriesHeatmap seriesHeatmap = new SeriesHeatmap();
		seriesHeatmap.setName("Sales per employee")
			.setBorderWidth(1)
			.getDataLabels()
				.setEnabled(true)
				.setColor(new Color("#000000"));
		seriesHeatmap.setDataAsArrayJavaObject(getSeriesData());
		chartOptions.getSeries().add(seriesHeatmap);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private List<Object> getSeriesData() {
		List<Object> array = new ArrayList<Object>();
		
		array.add(Arrays.asList(0, 0, 10));
		array.add(Arrays.asList(0, 1, 19));
		array.add(Arrays.asList(0, 2, 8));
		array.add(Arrays.asList(0, 3, 24));
		array.add(Arrays.asList(0, 4, 67));
		array.add(Arrays.asList(1, 0, 92));
		array.add(Arrays.asList(1, 1, 58));
		array.add(Arrays.asList(1, 2, 78));
		array.add(Arrays.asList(1, 3, 117));
		array.add(Arrays.asList(1, 4, 48));
		array.add(Arrays.asList(2, 0, 35));
		array.add(Arrays.asList(2, 1, 15));
		array.add(Arrays.asList(2, 2, 123));
		array.add(Arrays.asList(2, 3, 64));
		array.add(Arrays.asList(2, 4, 52));
		array.add(Arrays.asList(3, 0, 72));
		array.add(Arrays.asList(3, 1, 132));
		array.add(Arrays.asList(3, 2, 114));
		array.add(Arrays.asList(3, 3, 19));
		array.add(Arrays.asList(3, 4, 16));
		array.add(Arrays.asList(4, 0, 38));
		array.add(Arrays.asList(4, 1, 5));
		array.add(Arrays.asList(4, 2, 8));
		array.add(Arrays.asList(4, 3, 117));
		array.add(Arrays.asList(4, 4, 115));
		array.add(Arrays.asList(5, 0, 88));
		array.add(Arrays.asList(5, 1, 32));
		array.add(Arrays.asList(5, 2, 12));
		array.add(Arrays.asList(5, 3, 6));
		array.add(Arrays.asList(5, 4, 120));
		array.add(Arrays.asList(6, 0, 13));
		array.add(Arrays.asList(6, 1, 44));
		array.add(Arrays.asList(6, 2, 88));
		array.add(Arrays.asList(6, 3, 98));
		array.add(Arrays.asList(6, 4, 96));
		array.add(Arrays.asList(7, 0, 31));
		array.add(Arrays.asList(7, 1, 1));
		array.add(Arrays.asList(7, 2, 82));
		array.add(Arrays.asList(7, 3, 32));
		array.add(Arrays.asList(7, 4, 30));
		array.add(Arrays.asList(8, 0, 85));
		array.add(Arrays.asList(8, 1, 97));
		array.add(Arrays.asList(8, 2, 123));
		array.add(Arrays.asList(8, 3, 64));
		array.add(Arrays.asList(8, 4, 84));
		array.add(Arrays.asList(9, 0, 47));
		array.add(Arrays.asList(9, 1, 114));
		array.add(Arrays.asList(9, 2, 31));
		array.add(Arrays.asList(9, 3, 48));
		array.add(Arrays.asList(9, 4, 91));

    	return array;
    }
}
