package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesVenn;
import com.hyjavacharts.model.highcharts.series.seriesvenn.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class EulerDiagram extends DemoChartBase {
	private static final long serialVersionUID = -6640066571176059125L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getTitle().setText("Relationship between Euler and Venn diagrams");

		chartOptions.getTooltip()
			.setHeaderFormat("<span style=\"color:{point.color}\">\u2022</span> <span style=\"font-size: 14px\"> {point.point.name}</span><br/>")
			.setPointFormat("{point.description}<br><span style=\"font-size: 10px\">Source: Wikipedia</span>");
		
		SeriesVenn seriesVenn = new SeriesVenn();
		seriesVenn.setType(SeriesType.VENN);
		seriesVenn.setDataAsArrayObject(Arrays.asList(
				new Data().setValue(4).setSets(Arrays.asList("A")).setName("Euler diagrams").setDescription("An Euler diagram is a diagrammatic means of representing sets and their relationships. Unlike Venn diagrams, which show all possible relations between different sets, the Euler diagram shows only relevant relationships."),
				new Data().setValue(1).setSets(Arrays.asList("B")).setName("Venn diagrams").setDescription("In Venn diagrams the curves are overlapped in every possible way, showing all possible relations between the sets. They are thus a special case of Euler diagrams, which do not necessarily show all relations."),
				new Data().setValue(1).setSets(Arrays.asList("A", "B"))
						));
		chartOptions.getSeries().add(seriesVenn);
		
		return highChart;
	}
	
}
