package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.Series;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.responsive.Rules;
import com.hyjavacharts.model.highcharts.series.SeriesPie;
import com.hyjavacharts.model.highcharts.series.seriespie.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class DonutChartES extends DemoChartBase {
	private static final long serialVersionUID = -1795549261659620921L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
	    
		chartOptions.getChart().setType(ChartType.PIE);
		
		chartOptions.getTitle().setText("Browser market share, January, 2018");
		chartOptions.getSubtitle().setText("Source: <a href=\"http://statcounter.com\" target=\"_blank\">statcounter.com</a>");
	
		YAxis yAxi = new YAxis();
		yAxi.getTitle().setText("Total percent market share");
		chartOptions.getYAxis().add(yAxi);
		
		chartOptions.getPlotOptions().getPie().setShadowAsBoolean(false);
		chartOptions.getPlotOptions().getPie().getCenterAsArrayString().add("50%");
		chartOptions.getPlotOptions().getPie().getCenterAsArrayString().add("50%");
	
		chartOptions.getTooltip().setValueSuffix("%");
		
		SeriesPie seriesPie = new SeriesPie();
		seriesPie.setName("Browsers")
			.setSizeAsString("60%")
			.getDataLabels()
				.setColor(new Color("#ffffff"))
				.setDistance(-30)
				.getFormatter().setFunctionBody("return this.y > 5 ? this.point.name : null;");
		seriesPie.setDataAsArrayObject(getSeriesData(chartOptions));
		chartOptions.getSeries().add(seriesPie);
		
		seriesPie = new SeriesPie();
		seriesPie.setName("Versions")
			.setSizeAsString("80%")
			.setInnerSizeAsString("60%")
			.setId("versions")
			.getDataLabels().getFormatter().setFunctionBody("return this.y > 1 ? '<b>' + this.point.name + ':</b> ' + this.y + '%' : null;");
		seriesPie.setDataAsArrayObject(getSeriesDrilldownData(chartOptions));
		chartOptions.getSeries().add(seriesPie);

		ArrayList<Rules> rules = new ArrayList<Rules>();
		
		Rules r = new Rules();
		r.getCondition().setMaxWidth(400);
		rules.add(r);
		
		ArrayList<Series> series = new ArrayList<Series>();
		SeriesPie sp = new SeriesPie();
		sp.setId("versions").getDataLabels().setEnabled(false);
		series.add(sp);
		
		r = new Rules();
		r.getChartOptions().setSeries(series);
		rules.add(r);
		
		//chartOptions.getResponsive().setRules(rules);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData(ChartOptions chartOptions) {
		ArrayList<Data> data = new ArrayList<Data>();
		
		data.add(new Data().setName("Chrome").setY(62.74).setDrilldown("Chrome").setColor(chartOptions.getColors().get(2)));
		data.add(new Data().setName("Firefox").setY(10.57).setDrilldown("Firefox").setColor(chartOptions.getColors().get(1)));
		data.add(new Data().setName("Internet Explorer").setY(7.23).setDrilldown("Internet Explorer").setColor(chartOptions.getColors().get(0)));
		data.add(new Data().setName("Safari").setY(5.58).setDrilldown("Safari").setColor(chartOptions.getColors().get(3)));
		data.add(new Data().setName("Edge").setY(4.02).setDrilldown("Edge").setColor(chartOptions.getColors().get(5)));
		data.add(new Data().setName("Opera").setY(1.92).setDrilldown("Opera").setColor(chartOptions.getColors().get(4)));
		data.add(new Data().setName("Other").setY(7.62).setDrilldown("Other").setColor(chartOptions.getColors().get(6)));
		
		return data;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesDrilldownData(ChartOptions chartOptions) {
		ArrayList<Data> data = new ArrayList<Data>();
		
		double brightness;
		String color;
		
		// Chrome
		color = chartOptions.getColors().get(2).getColor();
		String[] name = new String[] {"Chrome v65.0", "Chrome v64.0", "Chrome v63.0", "Chrome v62.0", "Chrome v61.0", "Chrome v60.0", "Chrome v59.0", "Chrome v58.0", "Chrome v57.0", "Chrome v56.0", "Chrome v55.0", "Chrome v54.0", "Chrome v51.0", "Chrome v49.0", "Chrome v48.0", "Chrome v47.0", "Chrome v43.0", "Chrome v29.0"};
		Number[] y = new Number[] {0.1, 1.3, 53.02, 1.4, 0.88, 0.56, 0.45, 0.49, 0.32, 0.29, 0.79, 0.18, 0.13, 2.16, 0.13, 0.11, 0.17, 0.26};
		for (int i = 0; i < name.length; i++) {
			brightness = new BigDecimal(0.2 - ( new Double(i + 1) / new Double(name.length)) / 5.0)
					.setScale(4, RoundingMode.HALF_UP).doubleValue();
			data.add(new Data().setName(name[i]).setY(y[i]).setColor(new Color(color).brighten(brightness)));
		}
		
		// Firefox
		color = chartOptions.getColors().get(1).getColor();
		name = new String[] {"Firefox v58.0", "Firefox v57.0", "Firefox v56.0", "Firefox v55.0", "Firefox v54.0", "Firefox v52.0", "Firefox v51.0", "Firefox v50.0", "Firefox v48.0", "Firefox v47.0"};
		y = new Number[] {1.02, 7.36, 0.35, 0.11, 0.1, 0.95, 0.15, 0.1, 0.31, 0.12};
		for (int i = 0; i < name.length; i++) {
			brightness = new BigDecimal(0.2 - ( new Double(i + 1) / new Double(name.length)) / 5.0)
					.setScale(4, RoundingMode.HALF_UP).doubleValue();
			data.add(new Data().setName(name[i]).setY(y[i]).setColor(new Color(color).brighten(brightness)));
		}
	
		// Internet Explorer
		color = chartOptions.getColors().get(0).getColor();
		name = new String[] {"Internet Explorer v11.0", "Internet Explorer v10.0", "Internet Explorer v9.0", "Internet Explorer v8.0"};
		y = new Number[] {6.2, 0.29, 0.27, 0.47};
		for (int i = 0; i < name.length; i++) {
			brightness = new BigDecimal(0.2 - ( new Double(i + 1) / new Double(name.length)) / 5.0)
					.setScale(4, RoundingMode.HALF_UP).doubleValue(); 
			data.add(new Data().setName(name[i]).setY(y[i]).setColor(new Color(color).brighten(brightness)));
		}
		
		// Safari
		color = chartOptions.getColors().get(3).getColor();
		name = new String[] {"Safari v11.0", "Safari v10.1", "Safari v10.0", "Safari v9.1", "Safari v9.0", "Safari v5.1"};
		y = new Number[] {3.39, 0.96, 0.36, 0.54, 0.13, 0.2};
		for (int i = 0; i < name.length; i++) {
			brightness = new BigDecimal(0.2 - ( new Double(i + 1) / new Double(name.length)) / 5.0)
					.setScale(4, RoundingMode.HALF_UP).doubleValue();
			data.add(new Data().setName(name[i]).setY(y[i]).setColor(new Color(color).brighten(brightness)));
		}
		
		// Edge
		color = chartOptions.getColors().get(5).getColor();
		name = new String[] {"Edge v16", "Edge v15", "Edge v14", "Edge v13"};
		y = new Number[] {2.6, 0.92, 0.4, 0.1};
		for (int i = 0; i < name.length; i++) {
			brightness = new BigDecimal(0.2 - ( new Double(i + 1) / new Double(name.length)) / 5.0)
					.setScale(4, RoundingMode.HALF_UP).doubleValue();
			data.add(new Data().setName(name[i]).setY(y[i]).setColor(new Color(color).brighten(brightness)));
		}

		// Opera
		color = chartOptions.getColors().get(4).getColor();
		name = new String[] {"Opera v50.0", "Opera v49.0", "Opera v12.1"};
		y = new Number[] {0.96, 0.82, 0.14};
		for (int i = 0; i < name.length; i++) {
			brightness = new BigDecimal(0.2 - ( new Double(i + 1) / new Double(name.length)) / 5.0)
					.setScale(4, RoundingMode.HALF_UP).doubleValue();
			data.add(new Data().setName(name[i]).setY(y[i]).setColor(new Color(color).brighten(brightness)));
		}
		
		// Other
		color = chartOptions.getColors().get(6).getColor();
		name = new String[] {"Other"};
		y = new Number[] {7.62};
		for (int i = 0; i < name.length; i++) {
			brightness = new BigDecimal(0.2 - ( new Double(i + 1) / new Double(name.length)) / 5.0)
					.setScale(4, RoundingMode.HALF_UP).doubleValue();
			data.add(new Data().setName(name[i]).setY(y[i]).setColor(new Color(color).brighten(brightness)));
		}
		
		return data;
	}
}
