package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.hyjavacharts.model.highcharts.series.seriescolumn.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ColumnWithRotatedLabels extends DemoChartBase {
	private static final long serialVersionUID = -6848827552816517229L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.COLUMN);
		chartOptions.getTitle().setText("World's largest cities per 2017");
		chartOptions.getSubtitle().setText("Source: <a href=\"http://en.wikipedia.org/wiki/List_of_cities_proper_by_population\">Wikipedia</a>");
		
		XAxis xAxi = new XAxis();
		xAxi.setType(AxisType.CATEGORY)
			.getLabels().setRotation(-45)
			.getStyle().setFontSize("13px").setFontFamily("Verdana, sans-serif");
		chartOptions.getXAxis().add(xAxi);

		YAxis yAxi = new YAxis();
		yAxi.setAllowDecimals(false)
			.setMin(0)
			.getTitle().setText("Population (millions)");
		chartOptions.getYAxis().add(yAxi);
		
		chartOptions.getLegend().setEnabled(false);

		chartOptions.getTooltip()
			.setPointFormat("Population in 2017: <b>{point.y:.1f} millions</b>");

		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setName("Population")
			.getDataLabels()
				.setEnabled(true)
				.setRotation(-90)
				.setColor(new Color("#FFFFFF"))
				.setAlign(HorizontalAlign.RIGHT)
				.setFormat("{point.y:.1f}")
				.setY(10)
				.getStyle().setFontSize("13px").setFontFamily("Verdana, sans-serif");
		seriesColumn.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesColumn);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		Object[] PopulationData = new Object[] {"Shanghai", 24.2, "Beijing", 20.8, "Karachi", 14.9, "Shenzhen", 13.7, "Guangzhou", 13.1, "Istanbul", 12.7, "Mumbai", 12.4, "Moscow", 12.2, "São Paulo", 12.0, "Delhi", 11.7, "Kinshasa", 11.5, "Tianjin", 11.2, "Lahore", 11.1, "Jakarta", 10.6, "Dongguan", 10.6, "Lagos", 10.6, "Bengaluru", 10.3, "Seoul", 9.8, "Foshan", 9.3, "Tokyo", 9.3};
		
		for (int i = 0; i < PopulationData.length; i += 2) {
			array.add(new Data().setName((String) PopulationData[i]).setY((Number) PopulationData[i+1]));
		}

    	return array;
    }
}
