package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ColumnWithNegativeValues extends DemoChartBase {
	private static final long serialVersionUID = 7329656769144129899L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.COLUMN);
		chartOptions.getTitle().setText("Column chart with negative values");

		XAxis xAxi = new XAxis();
		xAxi.setCategories(Arrays.asList("Apples", "Oranges", "Pears", "Grapes", "Bananas"));
		chartOptions.getXAxis().add(xAxi);
		
		chartOptions.getCredits().setEnabled(false);
		
		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setName("John");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(5, 3, 4, 7, 2));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("Jane");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(2, -2, -3, 2, 1));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("Joe");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(3, 4, 4, -2, 5));
		chartOptions.getSeries().add(seriesColumn);
		
		return highChart;
	}
	
}
