package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.hyjavacharts.model.highcharts.series.seriescolumn.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ColumnWithDrilldown extends DemoChartBase {
	private static final long serialVersionUID = 4772887066559335383L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
	    
		chartOptions.getChart().setType(ChartType.COLUMN);
		
		chartOptions.getTitle().setText("Browser market shares. January, 2018");
		chartOptions.getSubtitle().setText("Click the columns to view versions. Source: <a href=\"http://statcounter.com\" target=\"_blank\">statcounter.com</a>");
	
		chartOptions.getXAxis().add(new XAxis().setType(AxisType.CATEGORY));
	
		YAxis yAxi = new YAxis();
		yAxi.getTitle().setText("Total percent market share");
		chartOptions.getYAxis().add(yAxi);
	
		chartOptions.getLegend().setEnabled(true);
		
		chartOptions.getPlotOptions().getColumn().setBorderWidth(0).getDataLabels().setEnabled(true).setFormat("{point.y:.1f}%");
	
		chartOptions.getTooltip()
			.setHeaderFormat("<span style=\"font-size:11px\">{series.name}</span><br>")
			.setPointFormat("<span style=\"color:{point.color}\">{point.name}</span>: <b>{point.y:.2f}%</b> of total<br/>");
		
		chartOptions.getExporting().setEnabled(false);
		
		// Browsers series
		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setName("Browsers").setColorByPoint(true);
		seriesColumn.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesColumn);
		
		// Drilldowns
		SeriesColumn seriesDrilldownColumn = new SeriesColumn();
		seriesDrilldownColumn.setName("Chrome").setId("Chrome");
		seriesDrilldownColumn.setDataAsArrayObject(getSeriesDrilldownData(1));
		chartOptions.getDrilldown().getSeries().add(seriesDrilldownColumn);
		
		seriesDrilldownColumn = new SeriesColumn();
		seriesDrilldownColumn.setName("Firefox").setId("Firefox");
		seriesDrilldownColumn.setDataAsArrayObject(getSeriesDrilldownData(2));
		chartOptions.getDrilldown().getSeries().add(seriesDrilldownColumn);
		
		seriesDrilldownColumn = new SeriesColumn();
		seriesDrilldownColumn.setName("Internet Explorer").setId("Internet Explorer");
		seriesDrilldownColumn.setDataAsArrayObject(getSeriesDrilldownData(3));
		chartOptions.getDrilldown().getSeries().add(seriesDrilldownColumn);
		
		seriesDrilldownColumn = new SeriesColumn();
		seriesDrilldownColumn.setName("Safari").setId("Safari");
		seriesDrilldownColumn.setDataAsArrayObject(getSeriesDrilldownData(4));
		chartOptions.getDrilldown().getSeries().add(seriesDrilldownColumn);
		
		seriesDrilldownColumn = new SeriesColumn();
		seriesDrilldownColumn.setName("Edge").setId("Edge");
		seriesDrilldownColumn.setDataAsArrayObject(getSeriesDrilldownData(5));
		chartOptions.getDrilldown().getSeries().add(seriesDrilldownColumn);
		
		seriesDrilldownColumn = new SeriesColumn();
		seriesDrilldownColumn.setName("Opera").setId("Opera");
		seriesDrilldownColumn.setDataAsArrayObject(getSeriesDrilldownData(6));
		chartOptions.getDrilldown().getSeries().add(seriesDrilldownColumn);
		
		seriesDrilldownColumn = new SeriesColumn();
		seriesDrilldownColumn.setName("Other").setId("Other");
		seriesDrilldownColumn.setDataAsArrayObject(getSeriesDrilldownData(7));
		chartOptions.getDrilldown().getSeries().add(seriesDrilldownColumn);

		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> data = new ArrayList<Data>();
		
		data.add(new Data().setName("Chrome").setY(62.74).setDrilldown("Chrome"));
		data.add(new Data().setName("Firefox").setY(10.57).setDrilldown("Firefox"));
		data.add(new Data().setName("Internet Explorer").setY(7.23).setDrilldown("Internet Explorer"));
		data.add(new Data().setName("Safari").setY(5.58).setDrilldown("Safari"));
		data.add(new Data().setName("Edge").setY(4.02).setDrilldown("Edge"));
		data.add(new Data().setName("Opera").setY(1.92).setDrilldown("Opera"));
		data.add(new Data().setName("Other").setY(7.62).setDrilldown(null));
		
		return data;
	}
	
	/**
	 * 
	 * @param series
	 * @return
	 */
	private ArrayList<Data> getSeriesDrilldownData(int series) {
		ArrayList<Data> data = new ArrayList<Data>();
		Object[] versionData = new Object[] {};
		
		if (series == 1) {
			versionData = new Object[] {"v65.0", 0.1 ,  "v64.0", 1.3 ,  "v63.0", 53.02 ,  "v62.0", 1.4 ,  "v61.0", 0.88 ,  "v60.0", 0.56 ,  "v59.0", 0.45 ,  "v58.0", 0.49 ,  "v57.0", 0.32 ,  "v56.0", 0.29 ,  "v55.0", 0.79 ,  "v54.0", 0.18 ,  "v51.0", 0.13 ,  "v49.0", 2.16 ,  "v48.0", 0.13 ,  "v47.0", 0.11 ,  "v43.0", 0.17 ,  "v29.0", 0.26 };
		}
		else if (series == 2) {
			versionData = new Object[] {"v58.0", 1.02 , "v57.0", 7.36 , "v56.0", 0.35 , "v55.0", 0.11 , "v54.0", 0.1 , "v52.0", 0.95 , "v51.0", 0.15 , "v50.0", 0.1 , "v48.0", 0.31 , "v47.0", 0.12 };
		}
		else if (series == 3) {
			versionData = new Object[] {"v11.0", 6.2 ,  "v10.0", 0.29 ,  "v9.0", 0.27 ,  "v8.0", 0.47 };
		}
		else if (series == 4) {
			versionData = new Object[] {"v11.0", 3.39 ,  "v10.1", 0.96 ,  "v10.0", 0.36 ,  "v9.1", 0.54 ,  "v9.0", 0.13 ,  "v5.1", 0.2 };
		}
		else if (series == 5) {
			versionData = new Object[] {"v16", 2.6 ,  "v15", 0.92 ,  "v14", 0.4 ,  "v13", 0.1 };
		}
		else if (series == 6) {
			versionData = new Object[] {"v50.0", 0.96, "v49.0", 0.82, "v12.1", 0.14};
		}
		
		for (int i = 0; i < versionData.length; i += 2) {
			data.add(new Data().setName((String) versionData[i]).setY((Number) versionData[i+1]));
		}
		
		return data;
	}
}
