package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesScatter;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ClickToAddAPoint extends DemoChartBase {
	private static final long serialVersionUID = -7133209582477197931L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.SCATTER)
			.setMargin(Arrays.asList(70, 50, 60, 80))
			.getEvents()
				.getClick()
				.setFunctionBody("var x = Math.round(e.xAxis[0].value), y = Math.round(e.yAxis[0].value), series = this.series[0]; series.addPoint([x, y]);")
				.addParameter("e");
		
		chartOptions.getTitle().setText("User supplied data");
		chartOptions.getSubtitle().setText("Click the plot area to add a point. Click a point to remove it.");

		chartOptions.getXAxisSingle()
			.setGridLineWidth(1)
			.setMinPadding(0.2)
			.setMaxPadding(0.2)
			.setMaxZoom(60);

		chartOptions.getYAxisSingle().setMinPadding(0.2).setMaxPadding(0.2).setMaxZoom(60).getTitle().setText("Value");
		chartOptions.getYAxisSingle().getPlotLinesSingle().setValue(0).setWidth(1).setColor(new Color("#808080"));
		
		chartOptions.getLegend().setEnabled(false);
		chartOptions.getExporting().setEnabled(false);
		
		chartOptions.getPlotOptions().getScatter()
			.setLineWidth(1)
			.getPoint().getEvents().getClick().setFunctionBody("if (this.series.data.length > 1) { this.remove(); }");
		
		SeriesScatter seriesScatter = new SeriesScatter();
		seriesScatter.setDataAsArrayJavaObject(Arrays.asList(Arrays.asList(20, 20), Arrays.asList(80, 80)));
		chartOptions.getSeries().add(seriesScatter);
		
		return highChart;
	}
	
}
