package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesBullet;
import com.hyjavacharts.model.highcharts.series.seriesbullet.Data;
import com.hyjavacharts.model.highcharts.yaxis.PlotBands;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class BulletGraph extends DemoChartBase {
	private static final long serialVersionUID = 4985104586452190688L;

	/**
	 * 
	 */
	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();

		chartOptions.getChart().setType(ChartType.BULLET)
			.setInverted(true)
			.setMarginLeft(135)
			.setMarginTop(40);

		chartOptions.getTitle().setText("2017 YTD");
		chartOptions.getLegend().setEnabled(false);
		
		XAxis xAxis = new XAxis();
		xAxis.getCategories().add("<span class=\"hc-cat-title\"><b>Revenue</b></span><br/>U.S. $ (1,000s)");
		chartOptions.getXAxis().add(xAxis);
		
		YAxis yAxis = new YAxis();
		yAxis.setGridLineWidth(0)
			.getTitle().setText(null);
		yAxis.getPlotBands().add(new PlotBands().setFrom(0).setTo(150).setColor(new Color("#666")));
		yAxis.getPlotBands().add(new PlotBands().setFrom(150).setTo(225).setColor(new Color("#999")));
		yAxis.getPlotBands().add(new PlotBands().setFrom(225).setTo(9e9).setColor(new Color("#bbb")));
		chartOptions.getYAxis().add(yAxis);
		
		chartOptions.getPlotOptions().getBullet()
			.setPointPadding(0.25)
			.setBorderWidth(0)
			.setColor(new Color("#000"))
			.getTargetOptions().setWidthAsString("200%");
		
		chartOptions.getCredits().setEnabled(false);
		chartOptions.getExporting().setEnabled(false);
		chartOptions.getTooltip().setPointFormat("<b>{point.y}</b> (with target at {point.target})");
		
		SeriesBullet seriesBullet = new SeriesBullet();
		seriesBullet.getDataAsArrayObject().add(new Data().setY(275).setTarget(250));
		chartOptions.getSeries().add(seriesBullet);
		
		return highChart;
	}
	
	/**
	 * 
	 */
	public BulletGraph() {
		setHeight("120px");
	}

}
