package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.ColorAxis;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.ZoomType;
import com.hyjavacharts.model.highcharts.series.SeriesBubble;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class BubbleWithColorAxis extends DemoChartBase {
	private static final long serialVersionUID = -1206378188723472633L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.BUBBLE)
			.setPlotBorderWidth(1)
			.setZoomType(ZoomType.XY);
		
		chartOptions.getTitle().setText("Highcharts bubbles with color axis");
		
		chartOptions.getColorAxis().add(new ColorAxis());
		chartOptions.getColorAxis().add(new ColorAxis().setMinColor(new Color("#434348")).setMaxColor(new Color("#e6ebf5")));
		
		XAxis xAxi = new XAxis();
		xAxi.setGridLineWidth(1);
		chartOptions.getXAxis().add(xAxi);
		
		YAxis yAxi = new YAxis();
		yAxi.setStartOnTick(false)
			.setEndOnTick(false);
		chartOptions.getYAxis().add(yAxi);

		SeriesBubble seriesBubble = new SeriesBubble();
		seriesBubble.setColorKey("x");
		seriesBubble.setDataAsArrayJavaObject(Arrays.asList(
				Arrays.asList(9, 81, 63), 
				Arrays.asList(98, 5, 89), 
				Arrays.asList(51, 50, 73),
				Arrays.asList(41, 22, 14),
				Arrays.asList(58, 24, 20),
				Arrays.asList(78, 37, 34),
				Arrays.asList(55, 56, 53),
				Arrays.asList(18, 45, 70),
				Arrays.asList(42, 44, 28),
				Arrays.asList(3, 52, 59),
				Arrays.asList(31, 18, 97),
				Arrays.asList(79, 91, 63),
				Arrays.asList(93, 23, 23),
				Arrays.asList(44, 83, 22)
				));
		chartOptions.getSeries().add(seriesBubble);
		
		seriesBubble = new SeriesBubble();
		seriesBubble.setColorKey("x").setColorAxisAsNumber(1);
		seriesBubble.setDataAsArrayJavaObject(Arrays.asList(
				Arrays.asList(42, 38, 20), 
				Arrays.asList(6, 18, 1), 
				Arrays.asList(1, 93, 55),
				Arrays.asList(57, 2, 90),
				Arrays.asList(80, 76, 22),
				Arrays.asList(11, 74, 96),
				Arrays.asList(88, 56, 10),
				Arrays.asList(30, 47, 49),
				Arrays.asList(57, 62, 98),
				Arrays.asList(4, 16, 16),
				Arrays.asList(46, 10, 11),
				Arrays.asList(22, 87, 89),
				Arrays.asList(57, 91, 82),
				Arrays.asList(45, 15, 98)
				));
		chartOptions.getSeries().add(seriesBubble);
		
		return highChart;
	}
	
}
