package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.DashStyle;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.ZoomType;
import com.hyjavacharts.model.highcharts.series.SeriesBubble;
import com.hyjavacharts.model.highcharts.series.seriesbubble.Data;
import com.hyjavacharts.model.highcharts.xaxis.PlotLines;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class BubbleChart extends DemoChartBase {
	private static final long serialVersionUID = -1206378188723472633L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.BUBBLE)
			.setPlotBorderWidth(1)
			.setZoomType(ZoomType.XY);
		chartOptions.getTitle().setText("Sugar and fat intake per country");
		chartOptions.getSubtitle().setText("Source: <a href=\"http://www.euromonitor.com/\">Euromonitor</a> and <a href=\"https://data.oecd.org/\">OECD</a>");
		
		chartOptions.getLegend().setEnabled(false);
		
		XAxis xAxi = new XAxis();
		xAxi.setGridLineWidth(1)
			.getTitle().setText("Daily fat intake");
		xAxi.getLabels().setFormat("{value} gr");
		
		PlotLines pl = new PlotLines();
		pl.getColor().setColor(Color.BLACK);
		pl.setDashStyle(DashStyle.DOT)
			.setWidth(2).setValue(65).setZIndex(3).getLabel().setRotation(0)
			.setY(15).setText("Safe fat intake 65g/day")
			.getStyle().setCssValue("{ fontStyle: 'italic' }");
		
		xAxi.getPlotLines().add(pl);
		chartOptions.getXAxis().add(xAxi);
		
		YAxis yAxi = new YAxis();
		yAxi.setStartOnTick(false)
			.setEndOnTick(false)
			.getTitle().setText("Daily sugar intake");
		yAxi.getLabels().setFormat("{value} gr");
		yAxi.setMaxPadding(0.2);
		
		com.hyjavacharts.model.highcharts.yaxis.PlotLines ypl = 
				new com.hyjavacharts.model.highcharts.yaxis.PlotLines();
		ypl.getColor().setColor(Color.BLACK);
		ypl.setDashStyle(DashStyle.DOT)		
			.setWidth(2)
			.setValue(50)
			.setZIndex(3)
			.getLabel()
				.setAlign(HorizontalAlign.RIGHT)
				.setX(-10)
				.setText("Safe sugar intake 50g/day")
				.getStyle().setCssValue("{ fontStyle: 'italic' }");
		yAxi.getPlotLines().add(ypl);
		chartOptions.getYAxis().add(yAxi);

		chartOptions.getTooltip()
			.setUseHTML(true)
			.setHeaderFormat("<table>")
			.setPointFormat("<tr><th colspan=\"2\"><h3>{point.description}</h3></th></tr>" +
					"<tr><th>Fat intake:</th><td>{point.x}g</td></tr>" +
					"<tr><th>Sugar intake:</th><td>{point.y}g</td></tr>" +
					"<tr><th>Obesity (adults):</th><td>{point.z}%</td></tr>")
			.setFooterFormat("</table>")
			.setFollowPointer(true);
		
		chartOptions.getPlotOptions()
			.getBubble().getDataLabels().setEnabled(true).setFormat("{point.name}");
		
		SeriesBubble seriesBubble = new SeriesBubble();
		seriesBubble.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesBubble);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setX(95).setY(95).setZ(13.8).setName("BE").setDescription("Belgium"));
		array.add(new Data().setX(86.5).setY(102.9).setZ(14.7).setName("DE").setDescription("Germany"));
		array.add(new Data().setX(80.8).setY(91.5).setZ(15.8).setName("FI").setDescription("Finland"));
		array.add(new Data().setX(80.4).setY(102.5).setZ(12).setName("NL").setDescription("Netherlands"));
		array.add(new Data().setX(80.3).setY(86.1).setZ(11.8).setName("SE").setDescription("Sweden"));
		array.add(new Data().setX(78.4).setY(70.1).setZ(16.6).setName("ES").setDescription("Spain"));
		array.add(new Data().setX(74.2).setY(68.5).setZ(14.5).setName("FR").setDescription("France"));
		array.add(new Data().setX(73.5).setY(83.1).setZ(10).setName("NO").setDescription("Norway"));
		array.add(new Data().setX(71).setY(93.2).setZ(24.7).setName("UK").setDescription("United Kingdom"));
		array.add(new Data().setX(69.2).setY(57.6).setZ(10.4).setName("IT").setDescription("Italy"));
		array.add(new Data().setX(68.6).setY(20).setZ(16).setName("RU").setDescription("Russia"));
		array.add(new Data().setX(65.5).setY(126.4).setZ(35.3).setName("US").setDescription("United States"));
		array.add(new Data().setX(65.4).setY(50.8).setZ(28.5).setName("HU").setDescription("Hungary"));
		array.add(new Data().setX(63.4).setY(51.8).setZ(15.4).setName("PT").setDescription("Portugal"));
		array.add(new Data().setX(64).setY(82.9).setZ(31.3).setName("NZ").setDescription("New Zealand"));

    	return array;
    }
}
