package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.LabelsOverflow;
import com.hyjavacharts.model.highcharts.constants.Layout;
import com.hyjavacharts.model.highcharts.constants.TitleAlign;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.series.SeriesBar;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class BasicBar extends DemoChartBase {
	private static final long serialVersionUID = 3193798714079102492L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.BAR);
		chartOptions.getTitle().setText("Historic World Population by Region");
		chartOptions.getSubtitle().setText("Source: <a href=\"https://en.wikipedia.org/wiki/World_population\">Wikipedia.org</a>");

		XAxis xAxis = new XAxis();
		xAxis.setCategories(Arrays.asList("Africa", "America", "Asia", "Europe", "Oceania"));
		xAxis.getTitle().setText(null);
		chartOptions.getXAxis().add(xAxis);

		YAxis yAxis = new YAxis();
		yAxis.setMin(0).getTitle().setText("Population (millions)").setAlign(TitleAlign.HIGH);
		yAxis.getLabels().setOverflow(LabelsOverflow.JUSTIFY);
		chartOptions.getYAxis().add(yAxis);

		chartOptions.getTooltip().setValueSuffix(" millions");
		chartOptions.getPlotOptions().getBar().getDataLabels().setEnabled(true);
		chartOptions.getCredits().setEnabled(false);

		chartOptions.getLegend().setLayout(Layout.VERTICAL).setAlign(HorizontalAlign.RIGHT)
			.setVerticalAlign(VerticalAlign.TOP).setX(-40).setY(80).setFloating(true)
			.setBorderWidth(1).setShadowAsBoolean(true)
			.getBackgroundColor().setColorValue("((Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF')");
		
		SeriesBar seriesBar = new SeriesBar();
		seriesBar.setName("Year 1800");
		seriesBar.setDataAsArrayNumber(Arrays.asList(107, 31, 635, 203, 2));
		chartOptions.getSeries().add(seriesBar);
		
		seriesBar = new SeriesBar();
		seriesBar.setName("Year 1900");
		seriesBar.setDataAsArrayNumber(Arrays.asList(133, 156, 947, 408, 6));
		chartOptions.getSeries().add(seriesBar);
		
		seriesBar = new SeriesBar();
		seriesBar.setName("Year 2000");
		seriesBar.setDataAsArrayNumber(Arrays.asList(814, 841, 3714, 727, 31));
		chartOptions.getSeries().add(seriesBar);
		
		seriesBar = new SeriesBar();
		seriesBar.setName("Year 2016");
		seriesBar.setDataAsArrayNumber(Arrays.asList(1216, 1001, 4436, 738, 40));
		chartOptions.getSeries().add(seriesBar);
		
		return highChart;
	}
	
}
