package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.Symbol;
import com.hyjavacharts.model.highcharts.series.SeriesArea;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class BasicArea extends DemoChartBase {
	private static final long serialVersionUID = 7385915024665933895L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.AREA);
		chartOptions.getTitle().setText("US and USSR nuclear stockpiles");
		chartOptions.getSubtitle().setText("Source: <a href=\"http://thebulletin.metapress.com/content/c4120650912x74k7/fulltext.pdf\">thebulletin.metapress.com</a>");
		
		XAxis xAxi = new XAxis();
		xAxi.setAllowDecimals(false)
			.getLabels().getFormatter().setFunctionBody("return this.value;");
		chartOptions.getXAxis().add(xAxi);
		
		YAxis yAxi = new YAxis();
		yAxi.getTitle().setText("Nuclear weapon states");
		yAxi.getLabels().getFormatter().setFunctionBody("return this.value / 1000 + 'k';");
		chartOptions.getYAxis().add(yAxi);

		chartOptions.getTooltip().setPointFormat("{series.name} produced <b>{point.y:,.0f}</b><br/>warheads in {point.x}");
		
		chartOptions.getPlotOptions()
			.getArea().setPointStart(1940)
			.getMarker().setEnabled(false).setSymbolAsEnum(Symbol.CIRCLE).setRadius(2).getStates().getHover().setEnabled(true);
		
		SeriesArea seriesArea = new SeriesArea();
		seriesArea.setName("USA");
		seriesArea.setDataAsArrayNumber(Arrays.asList(null, null, null, null, null, 6, 11, 32, 110, 235, 369, 640,
	            1005, 1436, 2063, 3057, 4618, 6444, 9822, 15468, 20434, 24126,
	            27387, 29459, 31056, 31982, 32040, 31233, 29224, 27342, 26662,
	            26956, 27912, 28999, 28965, 27826, 25579, 25722, 24826, 24605,
	            24304, 23464, 23708, 24099, 24357, 24237, 24401, 24344, 23586,
	            22380, 21004, 17287, 14747, 13076, 12555, 12144, 11009, 10950,
	            10871, 10824, 10577, 10527, 10475, 10421, 10358, 10295, 10104));
		chartOptions.getSeries().add(seriesArea);
		
		seriesArea = new SeriesArea();
		seriesArea.setName("USSR/Russia");
		seriesArea.setDataAsArrayNumber(Arrays.asList(null, null, null, null, null, null, null, null, null, null,
	            5, 25, 50, 120, 150, 200, 426, 660, 869, 1060, 1605, 2471, 3322,
	            4238, 5221, 6129, 7089, 8339, 9399, 10538, 11643, 13092, 14478,
	            15915, 17385, 19055, 21205, 23044, 25393, 27935, 30062, 32049,
	            33952, 35804, 37431, 39197, 45000, 43000, 41000, 39000, 37000,
	            35000, 33000, 31000, 29000, 27000, 25000, 24000, 23000, 22000,
	            21000, 20000, 19000, 18000, 18000, 17000, 16000));
		chartOptions.getSeries().add(seriesArea);
		
		return highChart;
	}
	
}
