package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesArea;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class AreaWithNegativeValues extends DemoChartBase {
	private static final long serialVersionUID = -6532879107180522400L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.AREA);
		chartOptions.getTitle().setText("Area chart with negative values");
		
		XAxis xAxi = new XAxis();
		xAxi.setCategories(Arrays.asList("Apples", "Oranges", "Pears", "Grapes", "Bananas"));
		chartOptions.getXAxis().add(xAxi);

		chartOptions.getCredits().setEnabled(false);
		
		SeriesArea seriesArea = new SeriesArea();
		seriesArea.setName("John");
		seriesArea.setDataAsArrayNumber(Arrays.asList(5, 3, 4, 7, 2));
		chartOptions.getSeries().add(seriesArea);
		
		seriesArea = new SeriesArea();
		seriesArea.setName("Jane");
		seriesArea.setDataAsArrayNumber(Arrays.asList(2, -2, -3, 2, 1));
		chartOptions.getSeries().add(seriesArea);
		
		seriesArea = new SeriesArea();
		seriesArea.setName("Joe");
		seriesArea.setDataAsArrayNumber(Arrays.asList(3, 4, 4, -2, 5));
		chartOptions.getSeries().add(seriesArea);
		
		return highChart;
	}
	
}
