package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.common.Stop;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.MinorTickPosition;
import com.hyjavacharts.model.highcharts.constants.TickPosition;
import com.hyjavacharts.model.highcharts.pane.Background;
import com.hyjavacharts.model.highcharts.series.SeriesGauge;
import com.hyjavacharts.model.highcharts.yaxis.PlotBands;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;
import com.webonlineapp.hyjavachartsdemo7flow.services.RestService;

public class AngularGauge extends DemoChartBase {
	private static final long serialVersionUID = -2159312163919747376L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
	    
		chartOptions.getChart()
			.setType(ChartType.GAUGE)
			.setPlotBorderWidth(0)
			.setPlotShadowAsBoolean(false)
			.setPlotBackgroundColor(null)
			.setPlotBackgroundImage(null);
		
		chartOptions.getTitle().setText("Speedometer");

		chartOptions.getPaneSingle()
			.setStartAngle(-150)
			.setEndAngle(150);
		
		Background b = new Background().setBorderWidth(0).setOuterRadiusAsString("109%");
		b.getBackgroundColor().getLinearGradient().setX1(0).setY1(0).setX2(0).setY2(1);
		b.getBackgroundColor().getStops().add(new Stop(0, new Color("#FFF")));
		b.getBackgroundColor().getStops().add(new Stop(1, new Color("#333")));
		chartOptions.getPaneSingle().getBackground().add(b);
		
		b = new Background().setBorderWidth(1).setOuterRadiusAsString("107%");
		b.getBackgroundColor().getLinearGradient().setX1(0).setY1(0).setX2(0).setY2(1);
		b.getBackgroundColor().getStops().add(new Stop(0, new Color("#333")));
		b.getBackgroundColor().getStops().add(new Stop(1, new Color("#FFF")));
		chartOptions.getPaneSingle().getBackground().add(b);
		
		chartOptions.getPaneSingle().getBackground().add(new Background());		// default background
		
		b = new Background().setBorderWidth(0).setOuterRadiusAsString("105%").setInnerRadiusAsString("103%");
		b.getBackgroundColor().setColor("#DDD");
		chartOptions.getPaneSingle().getBackground().add(b);
	
		YAxis yAxis = new YAxis();
		yAxis.getTitle().setText("km/h");
		
		yAxis.setMin(0)
			.setMax(200)
			.setMinorTickIntervalAsString("auto")
			.setMinorTickWidth(1)
			.setMinorTickLength(10)
			.setMinorTickPosition(MinorTickPosition.INSIDE)
			.getMinorTickColor().setColor("#666");
		
		yAxis.setTickPixelInterval(30)
			.setTickWidth(2)
			.setTickPosition(TickPosition.INSIDE)
			.setTickLength(10)
			.getTickColor().setColor("#666");
		yAxis.getLabels().setStep(2);
		
		yAxis.getPlotBands().add(new PlotBands().setFrom(0).setTo(120).setColor(new Color("#55BF3B")));
		yAxis.getPlotBands().add(new PlotBands().setFrom(120).setTo(160).setColor(new Color("#DDDF0D")));
		yAxis.getPlotBands().add(new PlotBands().setFrom(160).setTo(200).setColor(new Color("#DF5353")));
		
		chartOptions.getYAxis().add(yAxis);
		
		SeriesGauge sg = new SeriesGauge();
		sg.getTooltip().setValueSuffix(" km/h");
		sg.setName("Speed").getDataAsArrayNumber().add(80);
		chartOptions.getSeries().add(sg);
		
		chartOptions.getData().setCsvURL(RestService.getURI() + "/GaugeSpeedCSVData")
			.setEnablePolling(true)
			.setDataRefreshRate(3);
		
		return highChart;
	}

}
