package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.Cursor;
import com.hyjavacharts.model.highcharts.series.SeriesPie;
import com.hyjavacharts.model.highcharts.series.seriespie.Data;
import com.hyjavacharts.model.highcharts.series.seriespie.data.Accessibility;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class AccessiblePie extends DemoChartBase {
	private static final long serialVersionUID = 2962224991390182245L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.PIE);
		chartOptions.getTitle().setText("Primary desktop/laptop screen readers");
		chartOptions.getSubtitle().setText("Source: WebAIM. Click on point to visit official website");
		
		chartOptions.getTooltip().setValueSuffix("%").setBorderColor(new Color("#8ae"));

		chartOptions.getPlotOptions()
			.getPie().setCursor(Cursor.POINTER).setBorderWidth(3)
			.getDataLabels()
				.setEnabled(true)
				.setConnectorColor(new Color("#777"))
				.setFormat("<b>{point.name}</b>: {point.percentage:.1f} %");
		chartOptions.getPlotOptions()
			.getPie().getPoint().getEvents().getClick().setFunctionBody("window.location.href = this.className;");
		
		List<Color> patterns = initColors(chartOptions);

		SeriesPie seriesPie = new SeriesPie();
		seriesPie.setName("Screen reader usage");
		seriesPie.setDataAsArrayObject(new ArrayList<Data>(Arrays.asList(
				new Data().setName("NVDA").setY(40.6).setClassName("https://www.nvaccess.org")
					.setColor(patterns.get(0))
					.setAccessibility(new Accessibility().setDescription("This is the most used desktop screen reader")),
						
				new Data().setName("JAWS").setY(40.1).setClassName("https://www.freedomscientific.com/Products/Blindness/JAWS")
					.setColor(patterns.get(1)),
						
				new Data().setName("VoiceOver").setY(12.9).setClassName("http://www.apple.com/accessibility/osx/voiceover")
					.setColor(patterns.get(2)),

				new Data().setName("ZoomText").setY(2).setClassName("http://www.zoomtext.com/products/zoomtext-magnifierreader")
					.setColor(patterns.get(3)),
					
				new Data().setName("Other").setY(4.4).setClassName("http://www.apple.com/accessibility/osx/voiceover")
					.setColor(patterns.get(4))
					
				)));
		chartOptions.getSeries().add(seriesPie);
		
		chartOptions.getResponsive().getRulesSingle().getCondition().setMaxWidth(500);
		chartOptions.getResponsive().getRulesSingle().getChartOptions()
			.getPlotOptions().getSeries().getDataLabels().setFormat("<b>{point.name}</b>");
		
		
		return highChart;
	}
	
	/**
	 * 
	 * @param chartOptions
	 * @return
	 */
	private List<Color> initColors(ChartOptions chartOptions) {
		List<Color> patterns = new ArrayList<Color>();
		
		Color col = new Color();
		col.getPattern().setPathAsString("M 0 0 L 5 5 M 4.5 -0.5 L 5.5 0.5 M -0.5 4.5 L 0.5 5.5")
			.setColor(chartOptions.getColors().get(2)).setWidth(5).setHeight(5);
		patterns.add(col);
		
		col = new Color();
		col.getPattern().setPathAsString("M 0 5 L 5 0 M -0.5 0.5 L 0.5 -0.5 M 4.5 5.5 L 5.5 4.5")
			.setColor(chartOptions.getColors().get(0)).setWidth(5).setHeight(5);
		patterns.add(col);
		
		col = new Color();
		col.getPattern().setPathAsString("M 1.5 0 L 1.5 5 M 4 0 L 4 5")
			.setColor(chartOptions.getColors().get(3)).setWidth(5).setHeight(5);
		patterns.add(col);
		
		col = new Color();
		col.getPattern().setPathAsString("M 0 1.5 L 5 1.5 M 0 4 L 5 4")
			.setColor(chartOptions.getColors().get(1)).setWidth(5).setHeight(5);
		patterns.add(col);
		
		col = new Color();
		col.getPattern().setPathAsString("M 0 1.5 L 2.5 1.5 L 2.5 0 M 2.5 5 L 2.5 3.5 L 5 3.5")
			.setColor(chartOptions.getColors().get(4)).setWidth(5).setHeight(5);
		patterns.add(col);
		
		return patterns;
	}
	
}
