package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.Cursor;
import com.hyjavacharts.model.highcharts.constants.DashStyle;
import com.hyjavacharts.model.highcharts.series.SeriesSpline;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class AccessibleLine extends DemoChartBase {
	private static final long serialVersionUID = 5824250254164799011L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.SPLINE)
			.setDescription("Most commonly used desktop screen readers from January 2009 to July 2015 as reported in the Webaim Survey. JAWS remains the most used screen reader, but is steadily declining. ZoomText and WindowEyes are both displaying large growth from 2014 to 2015.");
	    
		chartOptions.getTitle().setText("Desktop screen readers from 2009 to 2015");
		chartOptions.getSubtitle().setText("Click on point to visit official website");

		chartOptions.getLegend().setSymbolWidth(40);

		YAxis yAxi = new YAxis();
		yAxi.getTitle().setText("Percentage usage");
		chartOptions.getYAxis().add(yAxi);
		
		XAxis xAxi = new XAxis();
		xAxi.getTitle().setText("Time");
		xAxi.setDescription("Time from January 2009 to July 2015")
			.setCategories(Arrays.asList("January 2009", "December 2010", "May 2012", "January 2014", "July 2015"));
		chartOptions.getXAxis().add(xAxi);

		chartOptions.getTooltip().setSplit(true);
	
		chartOptions.getPlotOptions()
			.getSeries()
				.setCursor(Cursor.POINTER)
				.getPoint().getEvents().getClick().setFunctionBody("window.location.href = this.series.options.description;");
		
		SeriesSpline seriesSpline = new SeriesSpline();
		seriesSpline.setName("JAWS").setDescription("https://www.freedomscientific.com/Products/Blindness/JAWS");
		seriesSpline.setDataAsArrayNumber(Arrays.asList(74, 69.6, 63.7, 63.9, 43.7));
		chartOptions.getSeries().add(seriesSpline);
		
		seriesSpline = new SeriesSpline();
		seriesSpline.setName("NVDA").setDescription("https://www.nvaccess.org")
			.setDashStyle(DashStyle.DOT);
		seriesSpline.setDataAsArrayNumber(Arrays.asList(8, 34.8, 43.0, 51.2, 41.4));
		chartOptions.getSeries().add(seriesSpline);

		seriesSpline = new SeriesSpline();
		seriesSpline.setName("VoiceOver").setDescription("http://www.apple.com/accessibility/osx/voiceover")
			.setDashStyle(DashStyle.SHORTDOT).setColor(chartOptions.getColors().get(7));
		seriesSpline.setDataAsArrayNumber(Arrays.asList(6, 20.2, 30.7, 36.8, 30.9));
		chartOptions.getSeries().add(seriesSpline);

		seriesSpline = new SeriesSpline();
		seriesSpline.setName("Window-Eyes").setDescription("http://www.gwmicro.com/window-eyes")
			.setDashStyle(DashStyle.DASH).setColor(chartOptions.getColors().get(0));
		seriesSpline.setDataAsArrayNumber(Arrays.asList(23, 19.0, 20.7, 13.9, 29.6));
		chartOptions.getSeries().add(seriesSpline);
		
		seriesSpline = new SeriesSpline();
		seriesSpline.setName("ZoomText").setDescription("http://www.zoomtext.com/products/zoomtext-magnifierreader")
			.setDashStyle(DashStyle.SHORTDASHDOT).setColor(chartOptions.getColors().get(8));
		seriesSpline.setDataAsArrayNumber(Arrays.asList(0, 6.1, 6.8, 5.3, 27.5));
		chartOptions.getSeries().add(seriesSpline);

		seriesSpline = new SeriesSpline();
		seriesSpline.setName("System Access To Go").setDescription("https://www.satogo.com")
			.setDashStyle(DashStyle.SHORTDASH).setColor(chartOptions.getColors().get(1));
		seriesSpline.setDataAsArrayNumber(Arrays.asList(0, 16.2, 22.1, 26.2, 6.9));
		chartOptions.getSeries().add(seriesSpline);

		seriesSpline = new SeriesSpline();
		seriesSpline.setName("ChromeVox").setDescription("http://www.chromevox.com")
			.setDashStyle(DashStyle.DASHDOT).setColor(chartOptions.getColors().get(4));
		seriesSpline.setDataAsArrayNumber(Arrays.asList(0, 0, 2.8, 4.8, 2.8));
		chartOptions.getSeries().add(seriesSpline);
		
		seriesSpline = new SeriesSpline();
		seriesSpline.setName("Other").setDescription("http://www.disabled-world.com/assistivedevices/computer/screen-readers.php")
			.setDashStyle(DashStyle.LONGDASH).setColor(chartOptions.getColors().get(7));
		seriesSpline.setDataAsArrayNumber(Arrays.asList(0, 7.4, 5.9, 9.3, 6.5));
		chartOptions.getSeries().add(seriesSpline);
		
		return highChart;
	}
	
	/**
	 * 
	 */
	public AccessibleLine() {
		setWidth("90%");
	}
}
