package com.webonlineapp.hyjavachartsdemo7flow.components;

import java.util.LinkedHashMap;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;

public class TabSheet extends Tabs {
	private static final long serialVersionUID = 9176309945609757061L;
	
	private LinkedHashMap<Tab, Component> tabsToPages = new LinkedHashMap<Tab, Component>();
	private Component selectedPage;
	
	
	/**
	 * 
	 * @param tab
	 * @param tabPage
	 */
	public void addTab(Tab tab, Component tabPage) {
		add(tab);
		tab.add(tabPage);

		tabsToPages.put(tab, tabPage);
		
		if (selectedPage == null) {
			selectedPage = tabPage;
			
			this.addSelectedChangeListener(event -> {
	        	selectedPage.setVisible(false);
	            
	        	selectedPage = tabsToPages.get(getSelectedTab());
	            selectedPage.setVisible(true);
	        });
		}
		else {
			tabPage.setVisible(false);
		}
	}
	
	/**
	 * 
	 * @param layout
	 */
	public void addComponentsToLayout(HorizontalLayout layout) {
		layout.add(this);
		
		tabsToPages.forEach((key, value) -> {
			layout.add(value);
		});
	}
	
	/**
	 * 
	 * @param layout
	 */
	public void addComponentsToLayout(VerticalLayout layout) {
		layout.add(this);
		
		tabsToPages.forEach((key, value) -> {
			layout.add(value);
		});
	}
}
