package com.webonlineapp.hyjavachartsdemo7flow.components;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Stream;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.server.VaadinServlet;
import com.webonlineapp.hyjavachartsdemo7flow.util.ServletUtil;

@Tag("div")
@CssImport("./css/prism.css")
@JsModule("./js/prism.js")
public class JavaSourceComponent extends Component implements HasComponents, HasSize {
	private static final long serialVersionUID = -2785683681551393855L;
	
	private boolean prettified = false;

	
	/**
	 * 
	 * @param javaSource
	 */
	public void setJavaSource(String chartFullName) {
		removeAll();
		prettified = false;
		
		String javaSource = getSourceCode(chartFullName);
		Html htmlPre = new Html("<pre><code class='language-java'>" + 
								javaSource.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\t", "    ") +
		        				"</code></pre>");
		htmlPre.getElement().getStyle().set("height", "65vh"); 

		add(htmlPre);
	}
	
	/**
	 * 
	 */
	public void prettify() {
		if (!prettified) {
			Page page = UI.getCurrent().getPage();
	    	page.executeJs("Prism.highlightAll();");
	    	prettified = true;
		}
	}
	
	/**
	 * 
	 * @param chartFullName
	 */
	private String getSourceCode(String chartFullName) {
		String chartName = chartFullName.substring(chartFullName.lastIndexOf(".") + 1, chartFullName.length());
		StringBuilder codeBuilder = new StringBuilder();
		
		
	    try (Stream<String> stream = Files.lines(Paths
	    		.get(ServletUtil.getBaseDirectory(VaadinServlet.getCurrent()) + "/examplecharts/" + chartName + ".java"), StandardCharsets.UTF_8)) {
	    	stream.forEach(line -> {
	    		if (!line.startsWith("//")) {
	    			codeBuilder.append(line).append("\n");
	    		}
	    	});
	    } 
	    catch (IOException e) {
	    	System.err.println("Caught IOException: " + e.getMessage());
	        e.printStackTrace();
	    }

		return codeBuilder.toString();
	}
	
}
