package com.webonlineapp.hyjavachartsdemo7flow.components;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;

@Tag("div")
@CssImport("./css/prism.css")
public class JavaScriptComponent extends Component implements HasComponents, HasSize {
	private static final long serialVersionUID = 5343841071531323147L;


	/**
	 * 
	 * @param javaScript
	 */
	public void setJavaScript(String javaScript) {
		removeAll();
		
		Html htmlPre = new Html("<pre class='jsoncode'><code class='jsoncode'><span class='token keyword'>" + 
								javaScript.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;") + 
								"</span></code></pre>");
		htmlPre.getElement().getStyle().set("height", "65vh"); 

		add(htmlPre);
	}
		
}
