package com.webonlineapp.hyjavachartsdemo7flow.components;

import java.util.Random;

import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.server.StreamResource;
import com.webonlineapp.hyjavachartsdemo7flow.exportserver.ChartImageSource;

@Tag("div")
public class HighchartImageComponent extends VerticalLayout {
	private static final long serialVersionUID = 5343841071531323147L;
	
	
	public void displayChartImage(String globalOptionsJs, String chartOptionsJs) {
		removeAll();
		
		String text = "Generate charts using the HyJavaCharts Library and the Highcharts Node.js Server. " + 
				"<br>The chart options Javascript is generated on the server using the HyJavaCharts library and sent to the Node.js server. " + 
				"<br>The Node.js server returns an image file. No Javascript is executed on the client browser.";
		
		add(new Html("<div>" + text + "</div>"));
		
		Button exportButton = new Button("Send to Node.js Server");
		exportButton.addThemeVariants(ButtonVariant.LUMO_PRIMARY);
		add(exportButton);

		exportButton.addClickListener(clickEvent -> {
			Random rand = new Random();
			
			removeAll();
    		StreamResource resource = new StreamResource("image" + rand.nextInt(999999999) + ".jpg", 
    				new ChartImageSource(globalOptionsJs, chartOptionsJs));

    		// Create an image component that gets its contents from the resource.
    		Image theChart = new Image(resource, "");
    		
    		theChart.setWidth("700px");
    		theChart.setHeight("525px");
    		
    		add(theChart);
    	});
	}
	
}
