package com.webonlineapp.hyjavachartsdemo7flow.components;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.Page;
import com.webonlineapp.hyjavachartsdemo7flow.util.ServletUtil;

@Tag("div")
public class HighchartComponent extends Component implements HasComponents, HasSize {
	private static final long serialVersionUID = 806054527112127036L;
	
	private static long chartId = 1;
	
	
	/**
	 * 
	 */
	public HighchartComponent() { 
		UI.getCurrent().getPage().addJavaScript(ServletUtil.getContextPath() + "/js/hc-demo.js");

        setId("highchart_" + getNextChartId());
 	}
	
	/**
	 * 
	 * @param chartOptions
	 */
	public void displayChart(String chartOptions) {
		displayChart("", chartOptions);
	}
	
	/**
	 * 
	 * @param globalOptions
	 * @param chartOptions
	 */
	public void displayChart(String globalOptions, String chartOptions) {
		Page page = UI.getCurrent().getPage();
		
		if (globalOptions != null && !globalOptions.equals("")) {
			String globalOptionsJs = "Highcharts.setOptions(" + globalOptions + ");";
			page.executeJs(globalOptionsJs);
		}

    	String chartOptionsJs = "Highcharts.chart('" + getId().get() + "', " + chartOptions + ");";
    	page.executeJs(chartOptionsJs);
	}
	
	/**
	 * 
	 * @return
	 */
	private long getNextChartId() {
		chartId++;
		
		if (chartId > 10000) {
			chartId = 1;
		}
		
		return chartId;
	}
	
}
