package com.webonlineapp.hyjavachartsdemo7flow.charts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.webonlineapp.hyjavachartsdemo7flow.examplecharts.*;

public class DemoCharts {
	// Web application charts
	private static final List<DemoChart> demoChartsList = new ArrayList<DemoChart>(Arrays.asList(
		// Line Charts
		new DemoChart("Line Charts"),
    	new DemoChart("Basic Line", new BasicLine()),
    	new DemoChart("Line Points", new LinePoints()),
    	new DemoChart("With Data Labels", new WithDataLabels()),
    	new DemoChart("With Annotations", new WithAnnotations()),
    	new DemoChart("Time Series Zoomable", new TimeSeriesZoomable()),
    	new DemoChart("Spline With Inverted Axis", new SplineWithInvertedAxis()),
    	new DemoChart("Spline With Symbols", new SplineWithSymbols()),
    	new DemoChart("Spline With PlotBands", new SplineWithPlotBands()),
    	new DemoChart("Time Data Irregular Intervals", new TimeDataWithIrregularIntervals()),
    	new DemoChart("Logarithmic Axis", new LogarithmicAxis()),
    	
    	// Area Charts
    	new DemoChart("Area Charts"),
    	new DemoChart("Basic Area", new BasicArea()),
    	new DemoChart("Area With Negative Values", new AreaWithNegativeValues()),
    	new DemoChart("Stacked Area", new StackedArea()),
    	new DemoChart("Percentage Area", new PercentageArea()),
    	new DemoChart("Area With Missing Points", new AreaWithMissingPoints()),
    	new DemoChart("Inverted Axis", new InvertedAxis()),
    	new DemoChart("Area Spline", new AreaSpline()),
    	new DemoChart("Area Range", new AreaRange()),
    	new DemoChart("Area Range And Line", new AreaRangeAndLine()),
    	
    	// Column and Bar Charts
    	new DemoChart("Column and Bar Charts"),
    	new DemoChart("Basic Bar", new BasicBar()),
    	new DemoChart("Stacked Bar", new StackedBar()),
    	new DemoChart("Bar With Negative Stack", new BarWithNegativeStack()),
    	new DemoChart("Basic Column", new BasicColumn()),
    	new DemoChart("Column With Caption", new ColumnWithCaption()),
    	new DemoChart("Column With Negative Values", new ColumnWithNegativeValues()),
    	new DemoChart("Stacked Column", new StackedColumn()),
    	new DemoChart("Stacked And Grouped Column", new StackedAndGroupedColumn()),
    	new DemoChart("Stacked Percentage Column", new StackedPercentageColumn()),
    	new DemoChart("Column With Rotated Labels", new ColumnWithRotatedLabels()),
    	new DemoChart("Column With Drilldown", new ColumnWithDrilldown()),
    	new DemoChart("Fixed Placement Columns", new FixedPlacementColumns()),
    	new DemoChart("Column Range", new ColumnRange()),
    	
    	// Pie Charts
    	new DemoChart("Pie Charts"),
    	new DemoChart("Pie Chart", new PieChart()),
    	new DemoChart("Pie With Legend", new PieWithLegend()),
    	new DemoChart("Donut Chart", new DonutChart()),
    	new DemoChart("Air Composition Donut", new AirCompositionDonut()),
    	new DemoChart("Semi Circle Donut", new SemiCircleDonut()),
    	new DemoChart("Pie With Drilldown", new PieWithDrilldown()),
    	new DemoChart("Pie With Gradient Fill", new PieWithGradientFill()),
    	new DemoChart("Pie With Monochrome Fill", new PieWithMonochromeFill()),
    	
    	// Scatter and Bubble Charts
    	new DemoChart("Scatter and Bubble Charts"),
    	new DemoChart("Scatter Plot", new ScatterPlot()),
    	new DemoChart("Bubble Chart", new BubbleChart()),
    	new DemoChart("Bubble With Color Axis", new BubbleWithColorAxis()),
    	new DemoChart("3D Bubbles", new ThreeDBubbles()),
    	new DemoChart("Packed Bubble Chart **NEW**", new PackedBubbleChart()),
    	new DemoChart("Packed Bubble With Color Axis **NEW**", new PackedBubbleWithColorAxis()),
    	new DemoChart("Split Packed Bubble Chart **NEW**", new SplitPackedBubbleChart()),
    	
    	// Combinations
    	new DemoChart("Combinations"),
    	new DemoChart("Column Line And Pie", new ColumnLineAndPie()),
    	new DemoChart("Dual Axis Line And Column", new DualAxisLineAndColumn()),
    	new DemoChart("Multiple Axis", new MultipleAxis()),
    	new DemoChart("Scatter With Regression Line", new ScatterWithRegressionLine()),
    	
    	// Accessible charts
    	new DemoChart("Accessible charts"),
    	new DemoChart("Accessible Line", new AccessibleLine()),
    	new DemoChart("Accessible Pie", new AccessiblePie()),
    	new DemoChart("Pattern Fill Pie", new PatternFillPieChart()),
    	new DemoChart("Pattern Fill Area", new PatternFillAreaChart()),
     	
    	// Dynamic Charts
    	new DemoChart("Dynamic Charts"),
    	new DemoChart("Dynamic Spline Updating", new DynamicSplineUpdating()),
    	new DemoChart("Click To Add A Point", new ClickToAddAPoint()),
    	new DemoChart("Live Data", new LiveData()),
    	new DemoChart("Server Monitoring", new ServerMonitoring()),
    	
    	// 3D Charts
    	new DemoChart("3D Charts"),
    	new DemoChart("3D Column", new ThreeDColumn()),
    	new DemoChart("3D Column With Null And Zeros", new ThreeDColumnWithNullAndZeros()),
    	new DemoChart("3D Column With Stacking", new ThreeDColumnWithStacking()),
    	new DemoChart("3D Cylinder **NEW**", new ThreeDCylinderChart()),
    	new DemoChart("3D Funnel **NEW**", new ThreeDFunnelChart()),
    	new DemoChart("3D Pyramid **NEW**", new ThreeDPyramidChart()),
    	new DemoChart("3D Pie", new ThreeDPie()),
    	new DemoChart("3D Donut", new ThreeDDonut()),
    	new DemoChart("3D Scatter Chart", new ThreeDScatterChart()),
    	
    	// Gauges
    	new DemoChart("Gauges"),
    	new DemoChart("Angular Gauge", new AngularGauge()),
    	new DemoChart("Solid Gauge", new SolidGauge()),
    	new DemoChart("Gauge With Dual Axis", new GaugeWithDualAxis()),
    	new DemoChart("VU Meter", new VUMeter()),
    	new DemoChart("Bullet Graph", new BulletGraph()),
    	
    	// Heat and Tree Maps
    	new DemoChart("Heat and Tree Maps"),
    	new DemoChart("Heat Map", new HeatMap()),
    	new DemoChart("Large Heat Map", new LargeHeatMap()),
    	new DemoChart("Tile Map Honeycomb", new TileMapHoneycomb()),
    	new DemoChart("Tree Map With Color Axis", new TreeMapWithColorAxis()),
    	new DemoChart("Tree Map With Levels", new TreeMapWithLevels()),
    	
    	// More Chart Types
    	new DemoChart("More Chart Types"),
    	new DemoChart("Polar Chart", new PolarChart()),
    	new DemoChart("Spider Web", new SpiderWeb()),
    	new DemoChart("Sunburst", new Sunburst()),
    	new DemoChart("Wind Rose", new WindRose()),
    	new DemoChart("Parallel Coordinates", new ParallelCoordinates()),
    	new DemoChart("Wind Barb", new WindBarb()),
    	new DemoChart("Vector Plot", new VectorPlot()),
    	new DemoChart("Box Plot", new BoxPlot()),
    	new DemoChart("Error Bar", new ErrorBar()),
    	new DemoChart("Histogram", new Histogram()),
    	new DemoChart("Waterfall", new Waterfall()),
    	new DemoChart("Variwide", new VariWide()),
    	new DemoChart("Variable Radius Pie", new VariableRadiusPie()),
    	new DemoChart("Bell Curve", new BellCurve()),
    	new DemoChart("Funnel Chart", new FunnelChart()),
    	new DemoChart("Pyramid Chart", new PyramidChart()),
    	new DemoChart("Polygon Series", new PolygonSeries()),
    	new DemoChart("Pareto Chart", new ParetoChart()),
    	new DemoChart("Sankey Diagram", new SankeyDiagram()),
    	new DemoChart("Dependency Wheel **NEW**", new DependencyWheel()),
    	new DemoChart("Organization Chart **NEW**", new OrganizationChart()),
    	new DemoChart("XRange Series", new XRangeSeries()),
    	new DemoChart("Word Cloud", new WordCloud()),
    	new DemoChart("Column Pyramid", new ColumnPyramid()),
    	new DemoChart("Timeline **NEW**", new Timeline()),
    	new DemoChart("Parliament Chart **NEW**", new ParliamentChart()),
    	new DemoChart("Venn Diagram", new VennDiagram()),
    	new DemoChart("Euler Diagram", new EulerDiagram()),
    	new DemoChart("Network Graph", new NetworkGraph())
		
		));
	
	// Export server charts
	private static final List<DemoChart> demoChartsExportServerList = new ArrayList<DemoChart>(Arrays.asList(
		// Line Charts
		new DemoChart("Line Charts"),
    	new DemoChart("Basic Line", new BasicLine()),
    	new DemoChart("Line Points", new LinePoints()),
    	new DemoChart("With Data Labels", new WithDataLabels()),
    	new DemoChart("With Annotations", new WithAnnotations()),
    	new DemoChart("Time Series Zoomable", new TimeSeriesZoomable()),
    	new DemoChart("Spline With Inverted Axis", new SplineWithInvertedAxis()),
    	new DemoChart("Spline With Symbols", new SplineWithSymbols()),
    	new DemoChart("Spline With PlotBands", new SplineWithPlotBands()),
    	new DemoChart("Time Data Irregular Intervals", new TimeDataWithIrregularIntervals()),
    	new DemoChart("Logarithmic Axis", new LogarithmicAxis()),
    	
    	// Area Charts
    	new DemoChart("Area Charts"),
    	new DemoChart("Basic Area", new BasicArea()),
    	new DemoChart("Area With Negative Values", new AreaWithNegativeValues()),
    	new DemoChart("Stacked Area", new StackedArea()),
    	new DemoChart("Percentage Area", new PercentageArea()),
    	new DemoChart("Area With Missing Points", new AreaWithMissingPoints()),
    	new DemoChart("Inverted Axis", new InvertedAxis()),
    	new DemoChart("Area Spline", new AreaSpline()),
    	new DemoChart("Area Range", new AreaRange()),
    	new DemoChart("Area Range And Line", new AreaRangeAndLine()),
    	
    	// Column and Bar Charts
    	new DemoChart("Column and Bar Charts"),
    	new DemoChart("Basic Bar", new BasicBar()),
    	new DemoChart("Stacked Bar", new StackedBar()),
    	new DemoChart("Bar With Negative Stack", new BarWithNegativeStack()),
    	new DemoChart("Basic Column", new BasicColumn()),
    	new DemoChart("Column With Caption", new ColumnWithCaption()),
    	new DemoChart("Column With Negative Values", new ColumnWithNegativeValues()),
    	new DemoChart("Stacked Column", new StackedColumn()),
    	new DemoChart("Stacked And Grouped Column", new StackedAndGroupedColumn()),
    	new DemoChart("Stacked Percentage Column", new StackedPercentageColumn()),
    	new DemoChart("Column With Rotated Labels", new ColumnWithRotatedLabels()),
    	new DemoChart("Column With Drilldown", new ColumnWithDrilldown()),
    	new DemoChart("Fixed Placement Columns", new FixedPlacementColumns()),
    	new DemoChart("Column Range", new ColumnRange()),
    	
    	// Pie Charts
    	new DemoChart("Pie Charts"),
    	new DemoChart("Pie Chart", new PieChart()),
    	new DemoChart("Pie With Legend", new PieWithLegend()),
    	//new DemoChart("Donut Chart", new DonutChart()),
    	new DemoChart("Air Composition Donut", new AirCompositionDonut()),
    	new DemoChart("Donut Chart", new DonutChartES()),
    	new DemoChart("Semi Circle Donut", new SemiCircleDonut()),
    	new DemoChart("Pie With Drilldown", new PieWithDrilldown()),
    	new DemoChart("Pie With Gradient Fill", new PieWithGradientFill()),
    	new DemoChart("Pie With Monochrome Fill", new PieWithMonochromeFill()),
    	
    	// Scatter and Bubble Charts
    	new DemoChart("Scatter and Bubble Charts"),
    	new DemoChart("Scatter Plot", new ScatterPlot()),
    	new DemoChart("Bubble Chart", new BubbleChart()),
    	new DemoChart("Bubble With Color Axis", new BubbleWithColorAxis()),
    	new DemoChart("3D Bubbles", new ThreeDBubbles()),
    	new DemoChart("Packed Bubble **NEW**", new PackedBubbleChart()),
    	new DemoChart("Packed Bubble With Color Axis **NEW**", new PackedBubbleWithColorAxis()),
    	new DemoChart("Split Packed Bubble Chart **NEW**", new SplitPackedBubbleChart()),
    	
    	// Combinations
    	new DemoChart("Combinations"),
    	new DemoChart("Column Line And Pie", new ColumnLineAndPie()),
    	new DemoChart("Dual Axis Line And Column", new DualAxisLineAndColumn()),
    	new DemoChart("Multiple Axis", new MultipleAxis()),
    	new DemoChart("Scatter With Regression Line", new ScatterWithRegressionLine()),
    	
    	// Accessible charts
    	new DemoChart("Accessible charts"),
    	new DemoChart("Accessible Line", new AccessibleLine()),
    	new DemoChart("Accessible Pie", new AccessiblePie()),
    	new DemoChart("Pattern Fill Pie", new PatternFillPieChart()),
    	new DemoChart("Pattern Fill Area", new PatternFillAreaChart()),
    	
    	// Dynamic Charts
    	new DemoChart("Dynamic Charts"),
    	new DemoChart("Dynamic Spline Updating", new DynamicSplineUpdating()),
    	new DemoChart("Click To Add A Point", new ClickToAddAPoint()),
    	//new DemoChart("Live Data  ***New in v6.1", new LiveData()),
    	//new DemoChart("Server Monitoring  ***New in v6.1", new ServerMonitoring()),
    	
    	// 3D Charts
    	new DemoChart("3D Charts"),
    	new DemoChart("3D Column", new ThreeDColumn()),
    	new DemoChart("3D Column With Null And Zeros", new ThreeDColumnWithNullAndZeros()),
    	new DemoChart("3D Column With Stacking", new ThreeDColumnWithStacking()),
    	new DemoChart("3D Cylinder **NEW**", new ThreeDCylinderChart()),
    	new DemoChart("3D Funnel **NEW**", new ThreeDFunnelChart()),
    	new DemoChart("3D Pyramid **NEW**", new ThreeDPyramidChart()),
    	new DemoChart("3D Pie", new ThreeDPie()),
    	new DemoChart("3D Donut", new ThreeDDonut()),
    	new DemoChart("3D Scatter Chart", new ThreeDScatterChart()),
    	
    	// Gauges
    	new DemoChart("Gauges"),
    	new DemoChart("Angular Gauge", new AngularGauge()),
    	new DemoChart("Solid Gauge", new SolidGauge()),
    	new DemoChart("Gauge With Dual Axis", new GaugeWithDualAxis()),
    	new DemoChart("VU Meter", new VUMeter()),
    	new DemoChart("Bullet Graph", new BulletGraph()),
    	
    	// Heat and Tree Maps
    	new DemoChart("Heat and Tree Maps"),
    	new DemoChart("Heat Map", new HeatMap()),
    	new DemoChart("Large Heat Map", new LargeHeatMap()),
    	new DemoChart("Tile Map Honeycomb", new TileMapHoneycomb()),
    	new DemoChart("Tree Map With Color Axis", new TreeMapWithColorAxis()),
    	new DemoChart("Tree Map With Levels", new TreeMapWithLevels()),
    	
    	// More Chart Types
    	new DemoChart("More Chart Types"),
    	new DemoChart("Polar Chart", new PolarChart()),
    	new DemoChart("Spider Web", new SpiderWeb()),
    	new DemoChart("Sunburst", new Sunburst()),
    	//new DemoChart("Wind Rose", new WindRose()),
    	new DemoChart("Wind Rose", new WindRoseES()),
    	new DemoChart("Parallel Coordinates", new ParallelCoordinates()),
    	new DemoChart("Wind Barb", new WindBarb()),
    	new DemoChart("Vector Plot", new VectorPlot()),
    	new DemoChart("Box Plot", new BoxPlot()),
    	new DemoChart("Error Bar", new ErrorBar()),
    	new DemoChart("Histogram", new Histogram()),
    	new DemoChart("Waterfall", new Waterfall()),
    	new DemoChart("Variwide", new VariWide()),
    	new DemoChart("Variable Radius Pie", new VariableRadiusPie()),
    	new DemoChart("Bell Curve", new BellCurve()),
    	new DemoChart("Funnel Chart", new FunnelChart()),
    	new DemoChart("Pyramid Chart", new PyramidChart()),
    	new DemoChart("Polygon Series", new PolygonSeries()),
    	new DemoChart("Pareto Chart", new ParetoChart()),
    	new DemoChart("Sankey Diagram", new SankeyDiagram()),
    	new DemoChart("Dependency Wheel **NEW**", new DependencyWheel()),
    	new DemoChart("Organization Chart **NEW**", new OrganizationChart()),
    	new DemoChart("XRange Series", new XRangeSeries()),
    	new DemoChart("Word Cloud", new WordCloud()),
    	new DemoChart("Column Pyramid", new ColumnPyramid()),
    	new DemoChart("Timeline **NEW**", new Timeline()),
    	new DemoChart("Parliament Chart **NEW**", new ParliamentChart()),
    	new DemoChart("Venn Diagram", new VennDiagram()),
    	new DemoChart("Euler Diagram", new EulerDiagram()),
    	new DemoChart("Network Graph", new NetworkGraphES())
		
		));

	/**
	 * 
	 * @param exportServer
	 * @return
	 */
	public static final List<DemoChart> getDemoChartsList(boolean exportServer) {
		return exportServer ? demoChartsExportServerList : demoChartsList;
	}


}
