package com.webonlineapp.hyjavachartsdemo7flow;

import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.applayout.AppLayout;
import com.vaadin.flow.component.applayout.DrawerToggle;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.page.Viewport;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.InitialPageSettings;
import com.vaadin.flow.server.PageConfigurator;

@Route("")
@Viewport("width=device-width, minimum-scale=1, initial-scale=1, user-scalable=yes, viewport-fit=cover")
public class MainView extends AppLayout implements HasComponents, PageConfigurator {
	private static final long serialVersionUID = 8803338074655839102L;
	
	boolean exportServer = false;

	
	/**
	 * 
	 */
	public MainView() {
		DemoPage demoPage = new DemoPage();

		addToNavbar(new DrawerToggle(), demoPage.buildHeading(this, exportServer));
		
		VerticalLayout content = new VerticalLayout();
		content.setWidthFull();
        demoPage.buildTab(content, exportServer);
        setContent(content);
        
        addToDrawer(demoPage.buildMenu(this, exportServer));
    }
	
	/**
	 * 
	 */
	@Override
    public void configurePage(InitialPageSettings settings) {
        settings.addFavIcon("icon", "icons/icon.png", "192x192");
    }
	
}
