package com.webonlineapp.hyjavachartsdemo7flow;

import java.util.Optional;

import com.hyjavacharts.LibraryInfo;
import com.hyjavacharts.chart.Highchart;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.applayout.AppLayout;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.H4;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChart;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoCharts;
import com.webonlineapp.hyjavachartsdemo7flow.components.HighchartComponent;
import com.webonlineapp.hyjavachartsdemo7flow.components.HighchartImageComponent;
import com.webonlineapp.hyjavachartsdemo7flow.components.JavaScriptComponent;
import com.webonlineapp.hyjavachartsdemo7flow.components.JavaSourceComponent;
import com.webonlineapp.hyjavachartsdemo7flow.components.TabSheet;
import com.webonlineapp.hyjavachartsdemo7flow.util.JavascriptUtil;

@CssImport(value = "./styles/app-layout-theme.css", themeFor = "vaadin-app-layout")
@CssImport(value = "./styles/drawer-toggle-theme.css", themeFor = "vaadin-drawer-toggle")
public class DemoPage {
	
	private TabSheet tabSheet = new TabSheet();
	private HighchartComponent highchartComponent = new HighchartComponent();
	private HighchartImageComponent highchartImageComponent = new HighchartImageComponent();
	private JavaSourceComponent page2 = new JavaSourceComponent();
	private JavaScriptComponent page3 = new JavaScriptComponent();
	private Checkbox hideMenu = new Checkbox("Hide Menu");
	private String prevChart = "";
	
	private String compHeight = "65vh";
	
	
	/**
	 * 
	 * @param view
	 * @param exportServer
	 * @return
	 */
	public Component buildHeading(AppLayout view, boolean exportServer) {
		VerticalLayout heading = new VerticalLayout();
		heading.setPadding(false);
        
        H4 title = new H4(exportServer ? "Highcharts Node.js Server Demonstration" : 
			"HyJavaCharts v" + LibraryInfo.getHyJavaChartsAPIVersion() + " Demonstration App");
        title.getStyle().set("color", "white");
         
        heading.add(title);
        
        return heading;
	}
	
	/**
	 * 
	 * @param view
	 * @param exportServer
	 * @return
	 */
	public Component buildMenu(AppLayout view, boolean exportServer) {
		Grid<DemoChart> demoCharts = new Grid<DemoChart>();
        demoCharts.setHeight("100%");
        
        demoCharts.addColumn(new ComponentRenderer<>(demoChart -> {
            if (demoChart.isHeading()) {
                return new Html("<b><i>" + demoChart.getName() + "</i></b>");
            } 
            else {
                return new Html("<span>" + "&nbsp;&nbsp;&nbsp;" + demoChart.getName() + "<span>");
            }
        }));
        
        demoCharts.setItems(DemoCharts.getDemoChartsList(exportServer));
        
        demoCharts.addSelectionListener(event -> {
        	Optional<DemoChart> first = event.getFirstSelectedItem();
        	
        	if (first.isPresent()) {
         		DemoChart selectedDemoChart = first.get();
        		
         		if (selectedDemoChart.getChart() != null) {
         			tabSheet.setSelectedIndex(0);

         			if (view.isOverlay()) {
         				view.setDrawerOpened(false);
         			}
         			
          			Highchart hc = selectedDemoChart.getChart().configure();
         			
          			String globalOptionsJs = hc.globalOptionsToJs();
         			String chartOptionsJs = hc.chartOptionsToJs();
         			
         			if (exportServer) {
          				highchartImageComponent.displayChartImage(globalOptionsJs, chartOptionsJs);
         			}
         			else {
         				if (selectedDemoChart.getChart().getHeight() == null) {
         					highchartComponent.setHeight(compHeight);
         				}
         				else {
         					highchartComponent.setHeight(selectedDemoChart.getChart().getHeight());
         				}
         				
         				highchartComponent.displayChart(globalOptionsJs, chartOptionsJs);
         				
         				if (prevChart.contains("Parallel Coordinates")) {
            				JavascriptUtil.removeStyleSheetRule(0);
            			}
            			
            			if (selectedDemoChart.getName().contains("Parallel Coordinates")) {
            				JavascriptUtil.addStyleSheetRule(JavascriptUtil.HIGHCHARTS_SERIES_HOVER, 0);
            			}
            			
            			prevChart = selectedDemoChart.getName();
         			}
 
         	        page2.setJavaSource(selectedDemoChart.getChart().getClass().getName());
         	        page3.setJavaScript(chartOptionsJs);
          		}
        	}
        });
        
        demoCharts.select(DemoCharts.getDemoChartsList(exportServer).get(1));
        
        VerticalLayout options = new VerticalLayout();
        options.add(hideMenu);

        hideMenu.addClickListener(clickEvent -> {
        	view.getElement().setAttribute("hide-menu", hideMenu.getValue());
        	JavascriptUtil.triggerResize();
    	});
        
        VerticalLayout menu = new VerticalLayout();
        menu.setId("the-menu");
        menu.setWidthFull();
        menu.setHeight("100%");
        menu.setSpacing(false);
        menu.setPadding(false);
        
        menu.add(demoCharts, options);
        
        return menu;
	}
	
	/**
	 * 
	 * @param main
	 * @param exportServer
	 */
	public void buildTab(VerticalLayout content, boolean exportServer) {
		tabSheet = new TabSheet();
		tabSheet.setWidth("100%");

		// Add tabs and pages to tabsheet
		tabSheet.addTab(new Tab(new HorizontalLayout(new Span(""), new Icon(VaadinIcon.BAR_CHART), 
				new Span("Example Chart"), new Span(""))), buildPage1(exportServer));
		
		tabSheet.addTab(new Tab(new HorizontalLayout(new Span(""), new Icon(VaadinIcon.COFFEE), 
				new Span("Java Source Code"), new Span(""))), buildPage2());
		
		tabSheet.addTab(new Tab(new HorizontalLayout(new Span(""), new Icon(VaadinIcon.CURLY_BRACKETS), 
				new Span("Generated Javascript"), new Span(""))), buildPage3());
		
		if (Properties.SHOW_TEST_TAB) {
			tabSheet.addTab(new Tab(new HorizontalLayout(new Span(""), new Icon(VaadinIcon.CHECK), 
					new Span("Test Chart Options"), new Span(""))), buildPage4());
		}
		
		Label header = new Label("Demonstrating more than 100 example charts using the HyJavaCharts Library v" + LibraryInfo.getHyJavaChartsAPIVersion());
		header.getStyle().set("font-weight", "700");
		content.add(header);
		Label spacer = new Label();
		content.add(spacer);
		
		// Add all tab components to the layout
        tabSheet.addComponentsToLayout(content);
        
        tabSheet.addSelectedChangeListener(event -> {
        	if (tabSheet.getSelectedIndex() == 1) {
        		page2.prettify();
        	}
        });
	}
	
	/**
	 * 
	 * @param exportServer
	 * @return
	 */
	private HorizontalLayout buildPage1(boolean exportServer) {
		HorizontalLayout page1 = new HorizontalLayout();
		page1.setWidth("100%");
		page1.setMargin(false);
        
        highchartComponent.setWidth("100%");
        highchartComponent.setHeight(compHeight);
        highchartImageComponent.setWidth("100%");
        highchartImageComponent.setHeight(compHeight);
        
        if (exportServer) {
        	page1.add(highchartImageComponent);
        }
        else {
        	page1.add(highchartComponent);
        }
        
        return page1;
	}
	
	/**
	 * 
	 * @return
	 */
	private JavaSourceComponent buildPage2() {
		page2.setHeight(compHeight);
		page2.setWidth("100%");
		
		return page2;
	}
	
	/**
	 * 
	 * @return
	 */
	private JavaScriptComponent buildPage3() {
		page3.setHeight(compHeight);
		page3.setWidth("100%");
		
		return page3;
	}
	
	/**
	 * 
	 * @return
	 */
	private VerticalLayout buildPage4() {
		VerticalLayout page4 = new VerticalLayout();
		
		TextArea chartOptions = new TextArea();
		chartOptions.setLabel("Chart Options");
		chartOptions.setClearButtonVisible(true);
		chartOptions.setPlaceholder("Paste chart options here...");
		chartOptions.setWidth("100%");
		chartOptions.setHeight("400px");
		
		Button displayButton = new Button("Display Chart");
		displayButton.addThemeVariants(ButtonVariant.LUMO_PRIMARY);
		
		HighchartComponent highchartTest = new HighchartComponent();
		highchartTest.setHeight(compHeight);
		highchartTest.setWidth("100%");
		
		page4.add(chartOptions);
		page4.add(displayButton);
		page4.add(highchartTest);

		displayButton.addClickListener(clickEvent -> {
			highchartTest.displayChart(chartOptions.getValue());
    	});

		return page4;
	}

}
